### Current DNS Security Challenges

- Few organizations actively monitor DNS for security, leaving it a weak point.
- Cisco reports that 91.3% of known malware uses DNS for command and control (C&C) or data exfiltration.
### Implementing DNS Security Solutions

- **Early Attack Prevention**:
    - DNS security can halt attacks early in the kill chain by blocking malicious IP connections and file downloads.
    - Prevents data exfiltration and C&C callbacks to attacker infrastructure across any port or protocol.

### ***Cisco Umbrella: A Cloud-Based DNS Security Solution***

- **Functionality**:
    - Blocks DNS name resolutions to malicious domains.
    - Simple deployment by pointing DNS servers to Cisco Umbrella.
- **Resolution Process**:
    - Safe destinations: Returns the IP address for DNS queries.
    - Unsafe destinations: Blocks the connection.
    - Risky/Unknown destinations: Uses an internal Intelligent Proxy for inspection.
        - Inspects content, examines ASN and domain relationships.
        - Detects cryptographically generated domain names.
        - Determines the disposition of web destinations.


**C&C (Command and Control) callbacks** in DNS refer to the use of DNS queries by malware to communicate with its **command and control servers**.